(function($, window, document) {
    'use strict';

    $.fn.mostrarFormPagos = function() {
        var metodo = $('select.indicar-pago').val();
        $('div.metodo-pago').hide();
        if(metodo == '2') { //Transferencia
            $('div.metodo-transferencia').show();

        }
        else if(metodo == '1') { //Deposito
            $('div.metodo-deposito').show();
        }
    }

    $.fn.siguienteForm = function() {
        var siguiente = true;
        var todos = $('.tab-area .nav-link.pestana-form');
        var activo = $('.tab-area .nav-link.pestana-form.active');

        var index = todos.index(activo);
        if(index == (todos.length - 1)) {
            siguiente = false;
        }
        else {
            var activar = todos[(index + 1)];
            $(activar).trigger('click');
        }

        return siguiente;
    }

    $.fn.tabError = function(inicial) {
        var errorElement = $('span.form-error-icon:first');
        if(errorElement.length > 0 ) {
            var divPadre = errorElement.parents('div.tab-pane.fade');
            var idUsar = divPadre.attr('id');
            $("a[href='#" + idUsar + "']").trigger( "click" );
        }
    };

    $.fn.activeTab = function(pulsado) {
        var todos = $('.tab-area .nav-link.pestana-form');
        var index = todos.index(pulsado);
        var boton = $('#boton-pagar-orden');

        if(index == (todos.length - 1)) {
            boton.html('Pagar Orden');
        }
        else {
            boton.html('Siguiente');
        }
    }

    $('#orden-pagar').on("submit", function(e) {
        $('#boton-pagar-orden').attr('disabled', true);
    });

    $('div.tab-area a.nav-link.pestana-form').on("click", function(e) {
        $.fn.activeTab($(this));
    });

    $('#boton-pagar-orden').on("click", function(e) {
        if($.fn.siguienteForm()) {
            e.preventDefault();
        }
    });

    $('select.indicar-pago').on("change", function(e) {
        $.fn.mostrarFormPagos();
    });

    $('.custom-file-input').on('change', function(){
        var fileName = $(this).val();
        $(this).next('.custom-file-label').html(fileName);
    });

    $(window).on("load", function(e) {
        $.fn.mostrarFormPagos();
        $.fn.tabError();
    });

})(jQuery, window, document);