
(function ($, window, document) {
    'use strict';

    $.fn.calcularCosto = function () {
        var costoTotal = 0;
        var costoReal = $('#orden-costo-real');
        $(".orden-estatus").each(function(index) {
            var input = $(this);
            var cardContenedor = $(input.parents('div.card')[0]);
            var costoIndividual = cardContenedor.find('span.costo-individual').data('costo');
            var estatus = input.val();
            if(estatus == '1') {    //APROBADO
                costoTotal += parseFloat(costoIndividual);
            }
        });
        costoReal.text($.fn.numberFormat(costoTotal));
    }

    $.fn.siguienteForm = function() {
        var siguiente = true;
        var todos = $('.tab-area .nav-link.pestana-form');
        var activo = $('.tab-area .nav-link.pestana-form.active');

        var index = todos.index(activo);
        if(index == (todos.length - 1)) {
            siguiente = false;
        }
        else {
            var activar = todos[(index + 1)];
            $(activar).trigger('click');
        }

        return siguiente;
    }

    $.fn.tabError = function() {
        var errorElement = $('span.form-error-icon:first');
        if(errorElement.length > 0 ) {
            var divPadre = errorElement.parents('div.tab-pane.fade');
            var idUsar = divPadre.attr('id');
            $("a[href='#" + idUsar + "']").trigger( "click" );
        }
    };


    $.fn.activeTab = function(pulsado) {
        var todos = $('.tab-area .nav-link.pestana-form');
        var index = todos.index(pulsado);
        var boton = $('#boton-procesar-orden');

        if(index == (todos.length - 1)) {
            boton.html('Procesar Orden');
        }
        else {
            boton.html('Siguiente');
        }
    }

    $('div.tab-area a.nav-link.pestana-form').on("click", function(e) {
        $.fn.activeTab($(this));
    });

    $('#boton-procesar-orden').on("click", function(e) {
        if($.fn.siguienteForm()) {
            e.preventDefault();
        }
    });

    $(".orden-estatus").on("change", function (event) {
        $.fn.calcularCosto();
    });

    $(window).on("load", function (e) {
        $.fn.calcularCosto();
        $.fn.tabError();
    });

})(jQuery, window, document);
