(function ($, window, document) {
    'use strict';

    /* ANIMACINO DE APRACION, REQUIERE ANIMATE.CSS */

    new WOW().init();

    $.fn.numberFormat = function (num, nDec, dSep, kSep) {

        nDec = nDec || 2;
        kSep = kSep || '.';
        dSep = dSep || ',';

        num = num.toString();
        var parts = num.split('.', 2);

        var decs = '00';
        if(parts.length == 2) {
            decs = parts[1];
        }

        var numFrmt = '';
        var cont = 0;
        var numbers = parts[0].split('');
        for (var i = numbers.length - 1; i >= 0; i--) {
            if(cont % 3 == 0 && cont != 0) {
                numFrmt = kSep + numFrmt;
            }
            cont++;
            numFrmt = numbers[i].toString() + numFrmt;
        }

        return numFrmt + dSep + decs;
    }


    $.fn.alertaModal = function (titulo, msj, tipo) {

        $('#modal-alerta-tipo')
            .removeClass('bg-primary').removeClass('bg-secondary').removeClass('bg-success').removeClass('bg-danger')
            .removeClass('bg-warning').removeClass('bg-info').removeClass('bg-light').removeClass('bg-dark');

        $('#modal-alerta-titulo').html(titulo);
        $('#modal-alerta-contenido').html(msj);
        $('#modal-alerta-tipo').addClass('bg-'+tipo);

        $('#modal-alerta').modal('show');
    };

    $('.modal-imagen').on('click', function(e) {
        var elemento = $(this);
        if(elemento.is('img') == false) {
            elemento = elemento.find('img');
        }
        var ruta = elemento.attr('src');
        var modal = $('#modal-imagen');
        $('#modal-imagen img').attr('src', ruta);
        modal.modal();
    });

    $('#buscar-dominio-disponible').on("click", function (e) {

        var boton = $(this);
        var nombre = $('#nombre-dominio');
        var extension = $('#extension-dominio');
        var urlBuscar = boton.data('url-buscar');
        var urlRegistro = boton.data('url-registro');

        var divResultado = $('#resultado-dominio-inicio');
        var divCargando = $('#resultado-dominio-cargando');

        boton.attr('disabled', true);
        divResultado.html('');
        divResultado.hide();
        divCargando.show();

        $.post(
            urlBuscar,
            {
                nombre: nombre.val(), 
                extension: extension.val()
            },
            function(data) {
                if(!data.error) {
                    if(data.disponible) {
                        var linkRegistro = urlRegistro+'?d='+data.nombre+'&e='+data.extensionId;
                        var msjFinal = '<div class="flash-alerta alert alert-success" role="alert">';
                        msjFinal += '<div class="d-flex justify-content-between"><div>'+data.mensaje+'</div>';
                        msjFinal += '<div class="ml-2"><a href="'+linkRegistro+'">¡Registralo Aquí!</a></div></div>';
                        divResultado.html(msjFinal);
                    }
                    else {
                        divResultado.html(
                            '<div class="flash-alerta alert alert-warning" role="alert">'+data.mensaje+'</div>'
                        );   
                    }
                }
                else {
                    divResultado.html(
                        '<div class="flash-alerta alert alert-danger" role="alert">'+data.mensaje+'</div>'
                    );
                }    
            }
        )
        .fail(function() {
            divResultado.html('<div class="flash-alerta alert alert-danger" role="alert">ERROR: Un error inesperado ha surgido, por favor intente nuevamente</div>');
        })
        .always(function() {
            boton.attr('disabled', false);
            divResultado.show();
            divCargando.hide();
        });
    });

    $(window).on("load", function (e) {
        $('body').css('overflow-y', 'visible');

        $('#preloader').fadeOut('slow', function () {
            $(this).remove();
        });

        $('[title!=""]').tooltip();

        if($(".flash-alerta").length > 0) {
            $(".flash-alerta").delay(20000).fadeOut('slow');
        }
    });

})(jQuery, window, document);

