<?php

namespace App\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

use App\Entity\Plan;
use App\Entity\PlanDetalle;
use App\Entity\PlanCaracteristica;

use App\Form\Caracteristica\CaracteristicaNuevaEditarType;

class CaracteristicaController extends AbstractController
{
    public function registrar(Request $request)
    {
        $caracteristica = new PlanCaracteristica();

        $form = $this->createForm(CaracteristicaNuevaEditarType::class, $caracteristica);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            if($form->isValid()) {

                $objDB = $this->getDoctrine()->getManager();
                $objDB->getConnection()->beginTransaction();
                try {
                    $objDB->persist($caracteristica);
                    $this->asignar($caracteristica);
                    $objDB->flush();
                    $objDB->getConnection()->commit();

                    $nombre = $form->get('nombre')->getData();
                    $this->addFlash('success', "La caracteristica \"{$nombre}\" ha sido creada");

                    return $this->redirectToRoute('caracteristica_listar');
                }
                catch (Exception $e) {
                    $objDB->getConnection()->rollBack();
                    $this->addFlash('danger', "Ha surgido un error inesperado al intentar guardar la informacion.");
                }
            }
        }

        return $this->render('admin/caracteristica/registrar.html.twig',
            [
                'form' => $form->createView()
            ]
        );
    }

    public function listar()
    {
        $caracteristicas = $this->getDoctrine()->getRepository(PlanCaracteristica::class)
            ->findBy([], ['estatus' => 'ASC', 'nombre' => 'ASC']);

        return $this->render('admin/caracteristica/listar.html.twig', [
            'caracteristicas' => $caracteristicas
        ]);
    }

    private function asignar(PlanCaracteristica $caracteristica) {
        $planes = $this->getDoctrine()->getRepository(Plan::class)->findBy(['estatus' => 1]);
        if($planes) {
            $objDB = $this->getDoctrine()->getManager();
            foreach ($planes as $plan) {
                $planDetalle = new PlanDetalle();
                $planDetalle->setDetalle(null);
                $planDetalle->setPlan($plan);
                $planDetalle->setCaracteristica($caracteristica);
                $objDB->persist($planDetalle);
            }
        }
    }

    public function activar($id)
    {
        $error = true;
        $mensaje = '';
        $response = new JsonResponse();
        $objCaract = $this->getDoctrine()->getRepository(PlanCaracteristica::class)->find($id);

        if($objCaract) {
            $activo = 'Activada';
            if($objCaract->getEstatus() == PlanCaracteristica::ESTATUS_ACTIVO) {
                $objCaract->setEstatus(PlanCaracteristica::ESTATUS_INACTIVO);
                $activo = 'Inactivo';
            }
            else {
                $objCaract->setEstatus(PlanCaracteristica::ESTATUS_ACTIVO);
            }

            $objDB = $this->getDoctrine()->getManager();
            $objDB->persist($objCaract);
            $objDB->flush();
            $response->setStatusCode(Response::HTTP_OK);
            $error = false;
            $mensaje = 'La Caracteristica ha sido ' .$activo. ' con exito.';
        }
        else {
            $mensaje = 'La Caracteristica no existe o ha sido eliminada.';
        }

        return $response->setData(['error' => $error, 'mensaje' => $mensaje]);
    }


    public function editar(Request $request, $id)
    {
        $caracteristica = $this->getDoctrine()->getRepository(PlanCaracteristica::class)->find($id);

        if(!$caracteristica) {
            return $this->redirectToRoute('caracteristica_listar');
        }
        else {
            $nombre = $caracteristica->getNombre();
            $id = $caracteristica->getId();

            $form = $this->createForm(CaracteristicaNuevaEditarType::class, $caracteristica);
            $form->handleRequest($request);

            if ($form->isSubmitted()) {
                if($form->isValid()) {

                    $objDB = $this->getDoctrine()->getManager();
                    $objDB->getConnection()->beginTransaction();
                    $objDB->persist($caracteristica);
                    $objDB->flush();
                    $objDB->getConnection()->commit();

                    $nombre = $form->get('nombre')->getData();
                    $this->addFlash('success', "La caracteristica \"{$nombre}\" ha sido modificado");

                    return $this->redirectToRoute('caracteristica_listar');
                }
            }
        }

        return $this->render('admin/caracteristica/editar.html.twig',
            [
                'form' => $form->createView(),
                'nombre' => $nombre,
                'id' => $id
            ]
        );
    }


    public function editar2(Request $request, $id)
    {
        $nombre = $request->request->get('nombre');
        $error = true;
        $mensaje = '';
        $response = new JsonResponse();
        $objPlanCaract = $this->getDoctrine()->getRepository(PlanCaracteristica::class);
        $caracteristica = $objPlanCaract->find($id);
        $existe = $objPlanCaract->existeNombre($id, $nombre);
        if($caracteristica) {
            if(!$existe) {
                $objDB = $this->getDoctrine()->getManager();
                try {
                    $caracteristica->setNombre($nombre);
                    $objDB->persist($caracteristica);
                    $objDB->flush();
                    $response->setStatusCode(Response::HTTP_OK);
                    $error = false;
                    $mensaje = 'La Caracteristica ha sido modificada con exito.';
                }
                catch (Exception $e) {
                    $objDB->getConnection()->rollBack();
                    $mensaje = 'Ha surgido un error inesperado al intentar eliminar la Caracteristica.';
                }
            }
            else {
                $mensaje = 'Ya existe una Caracteristica con el mismo nombre.';
            }
        }
        else {
            $mensaje = 'Ha surgido un error, intente de nuevo por favor.';
        }
        return $response->setData(['error' => $error, 'mensaje' => $mensaje]);
    }

}