<?php

namespace App\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

use App\Entity\Plan;
use App\Entity\PlanCosto;
use App\Entity\PlanDetalle;
use App\Entity\PlanCaracteristica;

use App\Form\Plan\PlanNuevoEditarType;

class PlanController extends AbstractController
{

    public function listar()
    {
        $planes = $this->getDoctrine()->getRepository(Plan::class)
            ->listadoAdmin();

        return $this->render('admin/plan/listar.html.twig', ['planes' => $planes]);
    }

    public function ver($id)
    {
        $plan = $this->getDoctrine()->getRepository(Plan::class)->mostrarAdmin($id);

        if($plan) {
            return $this->render('admin/plan/ver.html.twig', ['plan' => $plan[0]]);
        }
        else {
            $this->addFlash('danger', "El plan indicado no existe.");
            return $this->redirectToRoute('plan_listar');
        }
    }

    public function editar(Request $request, $id)
    {
        $plan = $this->getDoctrine()->getRepository(Plan::class)->find($id);
        if(!$plan) {
            return $this->redirectToRoute('plan_listar');
        }
        else {
            $nombre = $plan->getNombre();
            $form = $this->createForm(PlanNuevoEditarType::class, $plan);
            $form->handleRequest($request);

            if ($form->isSubmitted()) {
                if($form->isValid()) {
                    $objDB = $this->getDoctrine()->getManager();
                    $objDB->persist($plan);
                    $objDB->flush();
                    $this->addFlash('success', 'Se han actualizado el Plan con exito');
                    return $this->redirectToRoute('plan_listar');
                }
            }
        }

        return $this->render('admin/plan/editar.html.twig',
            [
                'form' => $form->createView(),
                'plan' => $plan,
                'nombre' => $nombre,
            ]
        );
    }

    public function registrar(Request $request)
    {
        $plan = new Plan();

        $this->costosNuevo($plan);
        $this->detallesNuevo($plan);

        $form = $this->createForm(PlanNuevoEditarType::class, $plan);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            if($form->isValid()) {
                $objDB = $this->getDoctrine()->getManager();
                $objDB = $this->getDoctrine()->getManager();
                $objDB->persist($plan);
                $objDB->flush();
                $this->addFlash('success', 'Se ha registrado el Plan con exito');
                return $this->redirectToRoute('plan_listar');
            }
        }

        return $this->render('admin/plan/registrar.html.twig',
            [
                'form' => $form->createView(),
                'plan' => $plan
            ]
        );
    }

    private function costosNuevo(Plan $plan)
    {
        $maxAnio = Plan::MAX_ANIO;
        for ($i = 1; $i <= $maxAnio; $i++) {
            $costo = new PlanCosto();
            $costo->setAnio($i);
            $plan->addCosto($costo);
        }
    }

    private function detallesNuevo(Plan $plan)
    {
        $caracteristicas = $this->getDoctrine()
            ->getRepository(PlanCaracteristica::class)
            ->findBy([], ['nombre' => 'ASC']);


        if($caracteristicas) {
            foreach ($caracteristicas as $caracteristica) {
                $detalle = new PlanDetalle();
                $detalle->setCaracteristica($caracteristica);
                $detalle->setDetalle(null);
                $detalle->setPlan($plan);
                $plan->addDetalle($detalle);
            }
        }
    }

}