<?php

namespace App\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

use App\Entity\Plan;
use App\Entity\PlanCosto;
use App\Entity\PlanDetalle;
use App\Entity\PlanCaracteristica;

use App\Entity\Extension;

use App\Util\Whois;

class PrincipalController extends AbstractController
{

    public function index() {

        $planes = $this->getDoctrine()->getRepository(Plan::class)->mostrar();
        $extensiones = $this->getDoctrine()->getRepository(Extension::class)->findBy(['estatus' => Extension::ESTATUS_ACTIVO]);

        return $this->render('website/inicio.html.twig', [
            'planes' => $planes,
            'extensiones' => $extensiones,
        ]);
    }

    public function buscarDominio(Request $request) {

        $error = false;
        $mensaje = "";
        $disponible = false;

        $nombre = $request->request->get('nombre', '');
        $extension = $request->request->get('extension', '');
        $nombreCompleto = $nombre.'.'.$extension;
        $existe = $this->getDoctrine()->getRepository(Extension::class)->findOneBy(['nombre' => $extension]);
        $whois = new Whois();

        $extensionId = 0;
        if($existe) {
            $disponible = $whois->setConsulta($nombre, $extension)->consultar();
            $extensionId = $existe->getId();
        }
        else {
            $error = true;
            $mensaje = "Seleccione una Extension de dominio valida por favor";
        }

        if($disponible === true) {
            $mensaje = "¡El dominio {$nombreCompleto} se encuentra disponible!";
        }
        elseif($error === false) {
            $errorWhois = $whois->getError();
            if($errorWhois === true) {
                $error = true;
                $codigo = $whois->getCodigo();
                if($codigo == -1) {
                    $mensaje = "Ingresar un nombre de dominio valido en minusculas (sin extension ni subdominio)";
                }
                elseif($codigo == 429) {
                    $mensaje = "Sistema de consulta saturado, por favor intente nuevamente";
                }
                elseif($codigo == 401 || $codigo == 403) {
                    $mensaje = "Problema de autenticacion en el Sistema de consulta, por favor intente nuevamente";
                }
                else {
                    $mensaje = "Ha surgido un error inesperado, por favor intente nuevamente";
                    if($codigo == 422) {
                        $resultado = $whois->getResultado();
                        if($resultado['code'] == 'UNSUPPORTED_TLD') {
                            $mensaje = 'Extension de Dominio no valida para consultar';
                        }
                    }
                }
            }
            else {
                $mensaje = "¡El dominio <u>{$nombreCompleto}</u> no se encuentra disponible!";
            }
        }

        $response = new JsonResponse();
        return $response->setData([
            'error' => $error, 
            'disponible' => $disponible, 
            'mensaje' => $mensaje, 
            'extensionId' => $extensionId,
            'nombre' => $nombre
        ]);
    }

    public function contacto() {

        return $this->render('website/contacto.html.twig', []);
    }

    public function mantenimiento() {

        return $this->render('website/mantenimiento.html.twig', []);
    }
}