<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity()
 * @ORM\Table(name="orden_factura")
 * @ORM\HasLifecycleCallbacks
 */
class OrdenFactura
{

    ///////////////
    // ATRIBUTOS //
    ///////////////

    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=80)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 6,
     *      max = 80
     * )
     */
    private $nombre;

    /**
     * @ORM\Column(type="string", length=20)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 6,
     *      max = 20
     * )
     */
    private $dni;


    /**
     * @ORM\Column(type="string", length=400)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 5,
     *      max = 100
     * )
     */
    private $giro;


    /**
     * @ORM\Column(type="string", length=13)
     * @Assert\NotBlank()
     * @Assert\Regex("/^\+?\d{8,13}/", message="Formato incorrecto de Fono")
     */
    private $fono;

    /**
     * @ORM\Column(type="string", length=13)
     * @Assert\NotBlank()
     * @Assert\Regex("/^\+?\d{8,13}/", message="Formato incorrecto de Telefono")
     */
    private $telefono;

    /**
     * @ORM\Column(type="string", length=400)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 5,
     *      max = 400
     * )
     */
    private $direccion;


    /**
     * @ORM\Column(type="string", length=64)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 2,
     *      max = 64
     * )
     */
    private $comuna;

    /**
     * @ORM\Column(type="string", length=64)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 2,
     *      max = 64
     * )
     */
    private $ciudad;

    /**
     * @ORM\ManyToOne(targetEntity="Pais")
     * @ORM\JoinColumn(name="pais_id", referencedColumnName="id", nullable=false)
     * @Assert\NotBlank()
     * @Assert\Valid
     */
    private $pais;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $updatedAt;


    /////////////////////
    // GETTER - SETTER //
    /////////////////////

    public function getOrdenCompra() {
        return $this->ordenCompra;
    }

    public function setOrdenCompra($algo) {
        //return $this->ordenCompra;
    }

    /**
     * @return int
     */
    public function getId() : ?int
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId(int $id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getNombre() : ?string
    {
        return $this->nombre;
    }

    /**
     * @param string $nombre
     *
     * @return self
     */
    public function setNombre(string $nombre)
    {
        $this->nombre = $nombre;
        return $this;
    }

    /**
     * @return string
     */
    public function getDni() : ?string
    {
        return $this->dni;
    }

    /**
     * @param string $dni
     *
     * @return self
     */
    public function setDni(string $dni)
    {
        $this->dni = $dni;
        return $this;
    }


    /**
     * @param string $giro
     *
     * @return self
     */
    public function setGiro(string $giro)
    {
        $this->giro = $giro;
        return $this;
    }

    /**
     * @return string
     */
    public function getGiro() :?string
    {
        return $this->giro;
    }


    /**
     * @param string $fono
     *
     * @return self
     */
    public function setFono(string $fono)
    {
        $this->fono = $fono;
        return $this;
    }

    /**
     * @return string
     */
    public function getFono() :?string
    {
        return $this->fono;
    }


    /**
     * @return string
     */
    public function getPais() : ?Pais
    {
        return $this->pais;
    }

    /**
     * @param Pais $pais
     *
     * @return self
     */
    public function setPais(Pais $pais)
    {
        $this->pais = $pais;
        return $this;
    }

    /**
     * @param string $telefono
     *
     * @return self
     */
    public function setTelefono(string $telefono)
    {
        $this->telefono = $telefono;
        return $this;
    }

    /**
     * @return string
     */
    public function getTelefono() :?string
    {
        return $this->telefono;
    }

    /**
     * @return string
     */
    public function getDireccion() : ?string
    {
        return $this->direccion;
    }

    /**
     * @param string $direccion
     *
     * @return self
     */
    public function setDireccion(string $direccion)
    {
        $this->direccion = $direccion;
        return $this;
    }

    /**
     * @return string
     */
    public function getComuna() : ?string
    {
        return $this->comuna;
    }

    /**
     * @param string $comuna
     *
     * @return self
     */
    public function setComuna(string $comuna)
    {
        $this->comuna = $comuna;
        return $this;
    }

    /**
     * @return string
     */
    public function getCiudad() : ?string
    {
        return $this->ciudad;
    }

    /**
     * @param string $ciudad
     *
     * @return self
     */
    public function setCiudad(string $ciudad)
    {
        $this->ciudad = $ciudad;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt() : ?\DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdateAt() : ?\DateTime
    {
        return $this->updatedAt;
    }


    /////////////////////////
    // LIFECYCLE CALLBACKS //
    /////////////////////////

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }


}