<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity()
 * @ORM\Table(name="persona")
 * @ORM\HasLifecycleCallbacks
 */
class Persona
{

    ///////////////
    // ATRIBUTOS //
    ///////////////

    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=80)
     * @Assert\NotBlank(groups={"nuevoUsuario"})
     * @Assert\Length(
     *      min = 6,
     *      max = 80,
     *      groups={"nuevoUsuario"}
     * )
     */
    private $nombre;

    /**
     * @ORM\Column(type="string", length=20)
     * @Assert\NotBlank(groups={"nuevoUsuario"})
     * @Assert\Length(
     *      min = 6,
     *      max = 20,
     *      groups={"nuevoUsuario"}
     * )
     */
    private $dni;

    /**
     * @ORM\Column(type="string", length=12)
     * @Assert\NotBlank(groups={"nuevoUsuario"})
     * @Assert\Regex("/^\+?\d{8,13}/", message="Formato incorrecto de Telefono", groups={"nuevoUsuario"})
     * @Assert\Length(
     *      min = 10,
     *      max = 12,
     *      groups={"nuevoUsuario"}
     * )
     */
    private $telefono;

    /**
     * @ORM\Column(type="string", length=400)
     * @Assert\NotBlank(groups={"nuevoUsuario"})
     * @Assert\Length(
     *      min = 10,
     *      max = 400,
     *      groups={"nuevoUsuario"}
     * )
     */
    private $direccion;

    /**
     * @ORM\Column(type="string", length=64)
     * @Assert\NotBlank(groups={"nuevoUsuario"})
     * @Assert\Length(
     *      min = 2,
     *      max = 64,
     *      groups={"nuevoUsuario"}
     * )
     */
    private $ciudad;

    /**
     * @ORM\ManyToOne(targetEntity="Pais")
     * @ORM\JoinColumn(name="pais_id", referencedColumnName="id", nullable=false)
     * @Assert\NotBlank(groups={"nuevoUsuario"})
     */
    private $pais;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $updatedAt;


    /////////////////////
    // GETTER - SETTER //
    /////////////////////


    /**
     * @return int
     */
    public function getId() : ?int
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId(int $id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getNombre() : ?string
    {
        return $this->nombre;
    }

    /**
     * @param string $nombre
     *
     * @return self
     */
    public function setNombre(string $nombre)
    {
        $this->nombre = $nombre;
        return $this;
    }

    /**
     * @return string
     */
    public function getDni() : ?string
    {
        return $this->dni;
    }

    /**
     * @param string $dni
     *
     * @return self
     */
    public function setDni(string $dni)
    {
        $this->dni = $dni;
        return $this;
    }

    /**
     * @return string
     */
    public function getPais() : ?Pais
    {
        return $this->pais;
    }

    /**
     * @param Pais $pais
     *
     * @return self
     */
    public function setPais(Pais $pais)
    {
        $this->pais = $pais;
        return $this;
    }

    /**
     * @param string $telefono
     *
     * @return self
     */
    public function setTelefono(string $telefono)
    {
        $this->telefono = $telefono;
        return $this;
    }

    /**
     * @return string
     */
    public function getTelefono() :?string
    {
        return $this->telefono;
    }

    /**
     * @return string
     */
    public function getDireccion() : ?string
    {
        return $this->direccion;
    }

    /**
     * @param string $direccion
     *
     * @return self
     */
    public function setDireccion(string $direccion)
    {
        $this->direccion = $direccion;
        return $this;
    }

    /**
     * @return string
     */
    public function getCiudad() : ?string
    {
        return $this->ciudad;
    }

    /**
     * @param string $ciudad
     *
     * @return self
     */
    public function setCiudad(string $ciudad)
    {
        $this->ciudad = $ciudad;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt() : ?\DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdateAt() : ?\DateTime
    {
        return $this->updatedAt;
    }


    /////////////////////////
    // LIFECYCLE CALLBACKS //
    /////////////////////////

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }


}