<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @ORM\Entity()
 * @ORM\Table(name="plan_costo")
 * @ORM\HasLifecycleCallbacks
 * @ORM\Entity(repositoryClass="App\Repository\PlanCostoRepository")
 */
class PlanCosto
{
    ///////////////
    // ATRIBUTOS //
    ///////////////

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(type="float")
     * @Assert\Regex(
     *     pattern = "/^(([0-9]{1,8})(\.[0-9]{1,2})?)$/",
     *     message="Debe ingresar un numero valido, opcionalmente con 2 decimales. Ejm: 15900.50",
     *     groups={"nuevo", "editar"}
     * )
     * @Assert\NotBlank(groups={"nuevo", "editar"})
     */
    private $costo;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Assert\NotBlank(groups={"nuevo", "editar"})
     * @Assert\Type("integer", groups={"nuevo", "editar"})
     * @Assert\Range(
     *      min = 1,
     *      max = ExtensionCosto::MAX_ANIO,
     *      groups={"nuevo", "editar"}
     * )
     */
    private $anio;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="Plan", inversedBy="costos")
     * @ORM\JoinColumn(name="plan_id", referencedColumnName="id", nullable=false)
     */
    private $plan;


    public function __construct()
    {
        $this->plan = new ArrayCollection();
    }


    /////////////////////
    // GETTER - SETTER //
    /////////////////////

    /**
     * @return int
     */
    public function getId() : ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCosto() : ?float
    {
        return $this->costo;
    }

    /**
     * @param string $nombre
     *
     * @return self
     */
    public function setCosto($costo) : self
    {
        $this->costo = $costo;
        return $this;
    }

    public function getAnio() : ?int
    {
        return $this->anio;
    }

    /**
     * @param string $nombre
     *
     * @return self
     */
    public function setAnio(int $anio) : self
    {
        $this->anio = $anio;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt() : ?\DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdateAt() : ?\DateTime
    {
        return $this->updatedAt;
    }

    /**
     * @return Plan
     */
    public function getPlan() : ?Plan
    {
        return $this->plan;
    }

    /**
     * @param Plan $plan
     *
     * @return self
     */
    public function setPlan(Plan $plan) : self
    {
        $this->plan = $plan;
        return $this;
    }

    /////////////////////////
    // LIFECYCLE CALLBACKS //
    /////////////////////////

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }


    ////////////////////////////
    // METODOS PERSONALIZADOS //
    ////////////////////////////

}