<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * @ORM\Entity()
 * @ORM\Table(name="plan_detalle")
 * @ORM\HasLifecycleCallbacks
 * @ORM\Entity(repositoryClass="App\Repository\PlanDetalleRepository")
 */
class PlanDetalle
{
    ///////////////
    // ATRIBUTOS //
    ///////////////

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Plan", inversedBy="detalles")
     * @ORM\JoinColumn(name="plan_id", referencedColumnName="id", nullable=false)
     */

    private $plan;

    /**
     * @ORM\ManyToOne(targetEntity="PlanCaracteristica")
     * @ORM\JoinColumn(name="plan_caracteristica_id", referencedColumnName="id", nullable=false)
     */
    private $caracteristica;

    /**
     * @var string|null
     *
     * @ORM\Column(type="string", length=50, nullable=true)
     * @Assert\Length(
     *      min = 1,
     *      max = 50,
     *      groups={"nuevo", "editar"}
     * )
     */
    private $detalle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $updatedAt;


    /////////////////
    // CONSTRUCTOR //
    /////////////////

    public function __construct()
    {
        $this->detalle = null;
    }


    /////////////////////
    // GETTER - SETTER //
    /////////////////////

    /**
     * @return int
     */
    public function getId() : ?int
    {
        return $this->id;
    }

    /**
     * @return Plan
     */
    public function getPlan() : ?Plan
    {
        return $this->plan;
    }

    /**
     * @param Plan $plan
     *
     * @return self
     */
    public function setPlan(Plan $plan) : self
    {
        $this->plan = $plan;
        return $this;
    }

    /**
     * @return PlanCaracteristica
     */
    public function getCaracteristica() : ?PlanCaracteristica
    {
        return $this->caracteristica;
    }

    /**
     * @param PlanCaracteristica $caracteristica
     *
     * @return self
     */
    public function setCaracteristica(PlanCaracteristica $caracteristica) : self
    {
        $this->caracteristica = $caracteristica;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDetalle() : ?string
    {
        return $this->detalle;
    }

    /**
     * @param string $detalle
     *
     * @return self
     */
    public function setDetalle(?string $detalle) : self
    {
        $this->detalle = $detalle;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt() : ?\DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdateAt() : ?\DateTime
    {
        return $this->updatedAt;
    }

    /////////////////////////
    // LIFECYCLE CALLBACKS //
    /////////////////////////

    /**
     * @ORM\PrePersist()
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate()
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }
}