<?php

namespace App\Form\Extension;

use App\Entity\Extension;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;

use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\CollectionType;

use Symfony\Component\Form\Extension\Core\Type\TextType;

use Symfony\Component\Validator\Constraints as Assert;

class ExtensionEditarType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('costo', CollectionType::class, [
                'entry_type' => ExtensionCostoEditarType::class,
                //'allow_add' => true,
                'by_reference' => true,
                'entry_options' => [
                    'required'=> true,
                    'constraints' => [new Assert\Valid(['groups' => ['editar']])],
                ]
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Extension::class,
            'validation_groups' => ['Default'],
        ]);
    }
}