<?php

namespace App\Form\Orden;

use App\Entity\Deposito;
use App\Entity\Banco;
use App\Entity\Cuenta;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

use Vich\UploaderBundle\Form\Type\VichImageType;

use Symfony\Component\Validator\Constraints as Assert;

class DepositoNuevoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('imageFile', VichImageType::class, [
                'download_uri' => false,
                'allow_delete' => false,
                'image_uri' => false,
                //'imagine_pattern' => '...',
                'attr' => ['class' => 'form-control-file'],
            ])
            ->add('tipo', ChoiceType::class, [
                'attr' => ['class' => 'custom-select'],
                'choices' => [
                    Deposito::TIPO_LABEL[Deposito::TIPO_EFECTIVO] =>Deposito::TIPO_EFECTIVO,
                    Deposito::TIPO_LABEL[Deposito::TIPO_CHEQUE] =>Deposito::TIPO_CHEQUE,
                ],
            ])
            ->add('cuenta', EntityType::class, [
                'class' => Cuenta::class,
                'attr' => ['class' => 'custom-select'],
                'choice_label' => function($cuenta, $key, $value) {
                    $formato = '%s | %s (%s)';
                    return sprintf($formato, 
                        $cuenta->getBanco()->getNombre(), 
                        $cuenta->getTitular(), 
                        $cuenta->getNumero()
                    );
                },
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('c')
                        ->where('c.estatus = :estatus')
                        ->setParameter('estatus', Cuenta::ESTATUS_ACTIVO);
                },
            ])
            ->add('fecha', DateType::class, [
                'attr' => ['class' => 'form-control'],
                'widget' => 'single_text'
            ])
            ->add('observacion', TextareaType::class, [
                'attr' => ['class' => 'form-control'],
                'required' => false
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Deposito::class,
            //'validation_groups' => ['nueva']
        ]);
    }
}