<?php

namespace App\Form\Orden;

use App\Entity\OrdenCompra;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

use Symfony\Component\Validator\Constraints as Assert;

class OrdenCompraNuevoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('ordenFactura', OrdenFacturaNuevoType::class, [
                'required'   => false,
            ])
            ->add('termino', CheckboxType::class, [
                'label'    => 'Acepto los Términos Legales y confirmo que no utilizaré este hosting para realizar “Spam” (más detalles en cláusula duodécimo)',
                'required' => true,
                'mapped' => false
            ])
            ->add('recibir', CheckboxType::class, [
                'label'    => 'Deseo recibir esta orden por Email',
                'required' => false,
                'mapped' => false,
                'attr' => ['checked' => 'checked']
            ])
            ->add('noFacturar', CheckboxType::class, [
                'label'    => 'No necesito una factura en este momento',
                'attr' => ['class' => 'f-omitir'],
                'required' => false,
                'mapped' => false
            ])
            ->add('emailCopia', EmailType::class, [
                'required' => false
            ])
            ->add('ordenHosting', CollectionType::class, [
                'entry_type' => OrdenHostingNuevoType::class,
                'by_reference' => false,
                'entry_options' => [
                    'constraints' => [new Assert\Valid()],
                ]
            ])
            ->add('ordenDominio', CollectionType::class, [
                'entry_type' => OrdenDominioNuevoType::class,
                //'allow_add' => true,
                //'error_bubbling ' => false,
                    //'validation_groups' => ['grpDominioPropio'],
                'by_reference' => false,
                //'constraints' => [new Assert\Valid()],
                'entry_options' => [
                    //  Parece que validation_groups en este lugar solo afecta a cada elemento
                    //      de la colleccion ([0],[1],...[N]) y no a la coleccion en si
                    'required'=> true,
                    'constraints' => [new Assert\Valid()],
                ]
            ])
            ->add('noPagar', CheckboxType::class, [
                'label'    => 'No realizare el pago en estos momentos',
                'attr' => ['class' => 'p-omitir'],
                'required' => false,
                'mapped' => false
            ])
            ->add('metodopago', ChoiceType::class, [
                'mapped' => false,
                'attr' => ['class' => 'custom-select indicar-pago'],
                'choices' => [
                    OrdenCompra::PAGO_LABEL[OrdenCompra::PAGO_TRANSFERENCIA] => OrdenCompra::PAGO_TRANSFERENCIA,
                    OrdenCompra::PAGO_LABEL[OrdenCompra::PAGO_DEPOSITO] => OrdenCompra::PAGO_DEPOSITO,
                    OrdenCompra::PAGO_LABEL[OrdenCompra::PAGO_WEBPAY] => OrdenCompra::PAGO_WEBPAY
                ],
                'choice_attr' => function($choiceValue, $key, $value) {
                    $attr = [];
                    if($value == '3') {
                        $attr = ['disabled' => 'disabled'];
                    }
                    return $attr;
                },
            ])
            ->add('transferencias', CollectionType::class, [
                'entry_type' => TransferenciaNuevoType::class,
                'by_reference' => false,
                'required' => false,
            ])
            ->add('depositos', CollectionType::class, [
                'entry_type' => DepositoNuevoType::class,
                'by_reference' => false,
                'required' => false,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OrdenCompra::class,
            'validation_groups' => function (FormInterface $form) {
                $grupos[] = 'emailCopia';

                $noFacturar = $form->get('noFacturar')->getData();
                if (false == $noFacturar) {
                    $grupos[] = 'OrdenFactura';
                }

                $noPagar = $form->get('noPagar')->getData();
                if (false == $noPagar) {
                    $metodopago = $form->get('metodopago')->getData();
                    if (OrdenCompra::PAGO_TRANSFERENCIA == $metodopago) {
                        $grupos[] = 'transferenciaNuevo';
                    }
                    else if (OrdenCompra::PAGO_DEPOSITO == $metodopago) {
                        $grupos[] = 'depositoNuevo';
                    }
                }

                return $grupos;
            }
        ]);
    }
}