<?php

namespace App\Form\Orden;

use App\Entity\OrdenDominio;
use App\Entity\Extension;
use App\Entity\ExtensionCosto;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

use Symfony\Component\Validator\Constraints\GroupSequence;

use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

use Symfony\Component\Validator\Constraints as Assert;

class OrdenDominioNuevoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('extension', EntityType::class, [
                'class' => Extension::class,
                'attr' => ['class' => 'calcular-dominio d-extension custom-select'],
                'choice_label' => 'nombre',
                'choice_attr' => function($extension, $key, $value) {
                    $tmp = [];
                    $costos = $extension->getCosto();
                    foreach ($costos as $costo) {
                        $tmp['data-costo-' . $costo->getAnio()] = $costo->getCosto();
                    }
                    return $tmp;
                },
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('e')
                        ->where('e.estatus = :estatus')
                        ->setParameter('estatus', Extension::ESTATUS_ACTIVO);
                },
            ])
            ->add('nombre', TextType::class,[
                'required' => false,
                'attr' => ['class' => 'd-nombre'],
                'by_reference' => false
            ])
            ->add('duracion', ChoiceType::class, [
                'attr' => ['class' => 'calcular-dominio d-duracion custom-select'],
                'choices' => $this->getDuracion(),
            ])
            ->add('omitirDominio', CheckboxType::class, [
                'attr' => ['class' => 'calcular-dominio d-omitir'],
                'label'    => 'No deseo comprar un Dominio en estos momentos',
                'mapped' => false,
                'required' => false
            ]);
    }

    private function getDuracion() {
        $anio = $label = [];
        for ($i=1; $i <= ExtensionCosto::MAX_ANIO; $i++) { 
            $tmp[$i] = $i;
            $label[$i] = $i . ' Año(s)';
        }
        return array_combine($label,$tmp);
    }


    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OrdenDominio::class,
            'validation_groups' => function (FormInterface $form) {
                $grupos = [];
                $omitirDominio = $form->get('omitirDominio')->getData();
                if (true != $omitirDominio) {
                    $grupos[] = new GroupSequence(['registrarOrd', 'dominioDisponible']);
                }
                return $grupos;
            }
        ]);
    }
}