<?php

namespace App\Form\Orden;

use App\Entity\OrdenHosting;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;

use Symfony\Component\Validator\Constraints as Assert;

class OrdenHostingProcesarType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('estatus', ChoiceType::class, [
                'attr' => ['class' => 'custom-select orden-estatus'],
                'choices' => [
                    OrdenHosting::ESTATUS_LABEL[OrdenHosting::ESTATUS_RECHAZADA]=>OrdenHosting::ESTATUS_RECHAZADA,
                    OrdenHosting::ESTATUS_LABEL[OrdenHosting::ESTATUS_APROBADA]=>OrdenHosting::ESTATUS_APROBADA,
                ],
            ])
            ->add('observacion', TextareaType::class, [
                'attr' => ['class' => 'form-control'],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OrdenHosting::class,
        ]);
    }
}