<?php

namespace App\Form\Usuario;

use App\Entity\Persona;
use App\Entity\Pais;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;

use Symfony\Component\Validator\Constraints as Assert;

class PersonaNuevoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nombre', TextType::class)
            ->add('dni', TextType::class)
            ->add('telefono', TextType::class)
            ->add('direccion', TextareaType::class)
            ->add('ciudad', TextType::class)
            ->add('pais', EntityType::class, [
                'class' => Pais::class,
                'choice_label' => 'nombre',
                'attr' => ['class' => 'custom-select']
            ]);
    }


    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Persona::class,
            // El resolver no funciona debido a que como estoy aplicando
            //      los grupos por anotaciones desde el @assert/valid{grupo}
            //      en la relacion de Usuario con Persona
            //
            //      Si fuese a traves de Form/Constraint/Valid{grupo}
            //      Este resolver si es aplicado/tomado en cuenta
            //'validation_groups' => ['nuevoUsuario']
        ]);
    }
}