<?php

namespace App\Repository;

use App\Entity\ExtensionCosto;
use Doctrine\ORM\EntityRepository;

class ExtensionCostoRepository extends EntityRepository
{
    public function costoAnio($extensionId, $anio) {
        $query = $this->createQueryBuilder('e')
            ->select('e.costo')
            ->andWhere('e.extension = :id')
            ->andWhere('e.anio = :anio')
            ->setParameter('id', $extensionId)
            ->setParameter('anio', $anio)
            ->setMaxResults(1)
            ->getQuery();

        return $query->getOneOrNullResult();
    }
}


