<?php

namespace App\Repository;

use App\Entity\OrdenCompra;
use Doctrine\ORM\EntityRepository;

class OrdenCompraRepository extends EntityRepository
{
    public function listarUsuario($id) {

        $entityManager = $this->getEntityManager();
        $ordenes = $entityManager->createQuery(
            "SELECT
                usu.id AS usuario, ord.id, ord.correlativo, ord.estatus, ord.createdAt, ord.fechaCierre
            FROM
                App\Entity\OrdenCompra ord,
                App\Entity\Usuario usu
            WHERE
                usu.id = :id AND
                usu.id = ord.usuario 
            ORDER BY
                ord.correlativo DESC"
        )
        ->setParameter('id', $id)
        ->execute();

        return $ordenes;
    }

    public function listado() {

        $entityManager = $this->getEntityManager();
        $planes = $entityManager->createQuery(
            'SELECT
                pl.id, pl.nivel, pl.descripcion, pl.nombre, pl.estatus, MIN(co.costo) costo
            FROM
                App\Entity\OrdenCompra pl,
                App\Entity\OrdenCompraCosto co
            WHERE
                co.plan = pl.id
            GROUP BY
                pl.id
            ORDER BY
                pl.nivel, pl.nombre , pl.id ASC'
        )
        ->execute();

        return $planes;
    }

    public function mostrar() {

        $entityManager = $this->getEntityManager();
        $planes = $entityManager->createQuery(
            'SELECT
                pl.id, pl.nombre, MIN(co.costo) costo
            FROM
                App\Entity\OrdenCompra pl,
                App\Entity\OrdenCompraCosto co
            WHERE
                co.plan = pl.id AND
                pl.estatus = :estatus
            GROUP BY
                pl.id
            ORDER BY
                pl.nivel, pl.nombre , pl.id ASC'
        )
        ->setParameter('estatus', OrdenCompra::ESTATUS_ACTIVO)
        ->execute();

        if(!empty($planes)) {
            $this->setDetallesMostrar($planes, [
                OrdenCompraCaracteristica::ESTATUS_ACTIVO
            ]);
        }

        return $planes;
    }
}