<?php
namespace App\Twig;

use Twig\Extension\RuntimeExtensionInterface;

use Symfony\Component\Serializer\Normalizer\DataUriNormalizer;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;

class DatauriRuntime implements RuntimeExtensionInterface
{
    private $container;

    public function __construct(Container $container) {
        $this->container = $container;
    }

    public function dataUri($path)
    {
        $normalizer = new DataUriNormalizer();
        $projectDir = $this->container->get('kernel')->getProjectDir();
        $avatar = $normalizer->normalize(
            new \SplFileObject($projectDir.'/public'.$path)
        );
        return $avatar;
    }
}