(function ($, window, document) {
    'use strict';

    $.fn.numberFormat = function (num, nDec, dSep, kSep) {

        nDec = nDec || 2;
        kSep = kSep || '.';
        dSep = dSep || ',';

        num = num.toString();
        var parts = num.split('.', 2);

        var decs = '00';
        if(parts.length == 2) {
            decs = parts[1];
        }

        var numFrmt = '';
        var cont = 0;
        var numbers = parts[0].split('');
        for (var i = numbers.length - 1; i >= 0; i--) {
            if(cont % 3 == 0 && cont != 0) {
                numFrmt = kSep + numFrmt;
            }
            cont++;
            numFrmt = numbers[i].toString() + numFrmt;
        }

        return numFrmt + dSep + decs;
    }


    $(document).bind("ajaxSend", function(xhr){
        $("#load-block-ui").show();
    }).bind("ajaxComplete", function(xhr){
        $("#load-block-ui").hide();
    });


    $.fn.alertaModal = function (titulo, msj, tipo) {

        $('#modal-alerta-tipo')
            .removeClass('bg-primary').removeClass('bg-secondary').removeClass('bg-success').removeClass('bg-danger')
            .removeClass('bg-warning').removeClass('bg-info').removeClass('bg-light').removeClass('bg-dark');

        $('#modal-alerta-titulo').html(titulo);
        $('#modal-alerta-contenido').html(msj);
        $('#modal-alerta-tipo').addClass('bg-'+tipo);

        $('#modal-alerta').modal('show');
    };

    $('.modal-imagen').on('click', function(e) {
        var elemento = $(this);
        if(elemento.is('img') == false) {
            elemento = elemento.find('img');
        }
        var ruta = elemento.attr('src');
        var modal = $('#modal-imagen');
        $('#modal-imagen img').attr('src', ruta);
        modal.modal();
    });

    $(window).on("load", function (e) {
        $('[title!=""]').tooltip();
        if($(".flash-alerta").length > 0) {
            $(".flash-alerta").delay(10000).fadeOut('slow');
        }
    });

})(jQuery, window, document);



