(this, function($, window, document) {
    "use strict";

    $('#modal-activar-caracteristica').on('show.bs.modal', function (event) {
        var trigger = $(event.relatedTarget);
        var url = trigger.data('url');
        var id = trigger.data('id');
        var nombre = trigger.data('nombre');
        var estatus = trigger.data('estatus');

        $('#btn-activar-caracteristica').data('url', url);
        $('#btn-activar-caracteristica').data('id', id);
        $('#caracteristica-nombre-activar').html(nombre);

        $('#caracteristica-estatus-activar').html('Activar');
        if(estatus == '1') {
            $('#caracteristica-estatus-activar').html('Desactivar');
        }
    });

    $('#btn-activar-caracteristica').on('click', function (event) {
        var btn = $(this);
        var url = btn.data('url');
        var id = btn.data('id');

        $.get(url, function(data) {
            if(!data.error) {
                btn.data('url', '').data('id', '');

                var tr = $('tr.caracteristica-' + id);
                var elemData = tr.find('[data-estatus]');
                var estatus = elemData.data('estatus');
                var icono = tr.find('.caracteristica-estatus i');
                var nombre = tr.find('.caracteristica-estatus .estatus-nombre');

                icono.toggleClass('fa-ban fa-check-circle');
                icono.toggleClass('text-success text-danger');
                if(estatus == '1') {
                    nombre.html('Inactivo');
                }
                else {
                    nombre.html('Activo');
                }

                $.fn.alertaModal('Exito!', data.mensaje, 'success');
            }
            else {
                $.fn.alertaModal('Error!', data.mensaje, 'danger');
            }
            $("#modal-activar-caracteristica").modal('hide');
        })
        .fail(function() {
            $("#modal-activar-caracteristica").modal('hide');
            $.fn.alertaModal('Error!', 'Un error inesperado ha surgido', 'danger');
        });
    });


})(jQuery, window, document);