(function($, window, document) {
    'use strict';

    $.fn.mostrarFormPagos = function() {
        var metodo = $('select.indicar-pago').val();
        $('div.metodo-pago').hide();
        if(metodo == '2') { //Transferencia
            $('div.metodo-transferencia').show();

        }
        else if(metodo == '1') { //Deposito
            $('div.metodo-deposito').show();
        }
    }


    $.fn.activeTab = function(pulsado) {
        var todos = $('.tab-area .nav-link');
        var index = todos.index(pulsado);
        var boton = $('#boton-registro-orden');

        if(index == (todos.length - 1)) {
            boton.html('Generar Orden');
        }
        else {
            boton.html('Siguiente');
        }
    }


    $.fn.siguienteForm = function() {
        var siguiente = true;
        var todos = $('.tab-area .nav-link');
        var activo = $('.tab-area .nav-link.active');

        if($.fn.tabIsValid(activo)) {
             var index = todos.index(activo);
            if(index == (todos.length - 1)) {
                siguiente = false;
            }
            else {
                var activar = todos[(index + 1)];
                $(activar).trigger('click');
            }
        }
        else {
            siguiente = false;
        }

        return siguiente;
    }

    $.fn.omitirFormulario = function() {

        var contenedor = $('.orden-dominio, .orden-factura, .orden-hosting, .formas-pago');
        contenedor.each(function( index ) {
            var omitir = $(this).find('.h-omitir, .d-omitir, .f-omitir, .p-omitir').first();
            $(this).find('input, textarea').attr('readonly', false);
            $(this).find('button').attr('disabled', false);
            $(this).find('input[type=file]').attr('disabled', false);
            $(this).find('select').attr('disabled', false);
            if(omitir.is(":checked") == true) {
                $(this).find('input, textarea').attr('readonly', true);
                $(this).find('input[type=file]').attr('disabled', true);
                $(this).find('select').attr('disabled', true);
                $(this).find('button').attr('disabled', true);
            }
            omitir.attr('readonly', false);
        });
    }


    $.fn.cargarDefault = function() {
        var form = $('#orden-registro');
        var hostingPlan = form.data('hosting-plan');
        var dominio = form.data('dominio');
        var extension = form.data('extension');
        var idUsar = '';

        if(dominio.length > 0){
            $('.d-nombre:first').val(dominio);
        }

        var ext = $('.calcular-dominio.d-extension:first option[value="'+extension+'"]');
        if(ext.length > 0) {
            ext.attr('selected', true);
            idUsar = ext.parents('div.tab-pane.fade').attr('id');
            $('.calcular-hosting.h-omitir:first').attr('checked', true);
        }

        var plan = $('.calcular-hosting.h-plan:first option[value="'+hostingPlan+'"]');
        if(plan.length > 0) {
            plan.attr('selected', true);
            idUsar = plan.parents('div.tab-pane.fade').attr('id');
            $('.calcular-dominio.d-omitir:first').attr('checked', true);
        }

        if(idUsar.length > 0) {
            $("a[href='#" + idUsar + "']").trigger( "click" );
        }
    }

    $.fn.tabIsValid = function(tabActual) {
        var selector = tabActual.attr('href');
        var campos = $(selector).find('input, textarea, select');
        var valid = true;
        campos.each(function(index) {
            var campo = $(this);
            if(campo.is(':invalid')) {
                valid = false;
            }
        });
        return valid;
    }

    $.fn.formIsValid = function() {
        var valid = true;
        var errorElement = $('#orden-registro').find(':invalid').first();
        if(errorElement.length == 1) {
            var divPadre = errorElement.parents('div.tab-pane.fade');
            var idUsar = divPadre.attr('id');
            $("a[href='#" + idUsar + "']").trigger( "click" );
            valid = false;
        }
        return valid;
    }

    $.fn.tabError = function(inicial) {
        inicial = inicial | false;
        var errorElement = $('span.form-error-icon:first');
        if(errorElement.length > 0 ) {
            var divPadre = errorElement.parents('div.tab-pane.fade');
            var idUsar = divPadre.attr('id');
            $("a[href='#" + idUsar + "']").trigger( "click" );
        }
    };


    $.fn.calcularTotal = function() {
        var dominios = $('div.orden-dominio');
        var hostings = $('div.orden-hosting');
        var total = 0;

        dominios.each(function( index ) {
            var elemento = $(this).find('.calcular-dominio:first');
            var subtotal = $.fn.calcularDominio(elemento);
            subtotal = parseFloat(subtotal);
            total += subtotal;
        });

        hostings.each(function( index ) {
            var elemento = $(this).find('.calcular-hosting:first');
            var subtotal = $.fn.calcularHosting(elemento);
            subtotal = parseFloat(subtotal);
            total += subtotal;
        });

        $('.resumen-precio-total').html('CLP $' + $.fn.numberFormat(total));
        return total;
    };


    $.fn.calcularHosting = function(input) {

        var numero = input.attr('id').match(/\d+/g);
        var divPadre = input.parents('div.orden-hosting');
        var plan = divPadre.find('.h-plan.calcular-hosting');
        var duracion = divPadre.find('.h-duracion.calcular-hosting');
        var omitir = divPadre.find('.h-omitir.calcular-hosting');

        var hResumen = $('.hosting-resumen-' + numero);
        var hPrecio = $('.hosting-precio-' + numero);
        var costo = 0;

        if(omitir.is(":checked") == false) {
            var anios = duracion.val();
            costo = plan.find(':selected').data('costo-' + anios);
            var label = plan.find(':selected').html();
            hResumen.html('Hosting <strong>' + label + '</strong> (' + anios + ' años)');
        }
        else {
            hResumen.html('Hosting <strong>No aplica</strong>');
        }
        hPrecio.html('$' + $.fn.numberFormat(costo));
        return costo;
    }


    $('.buscar-dominio-disponible').on("click", function(e) {
        var boton = $(this);
        var divPadre = boton.parents('div.orden-dominio');
        var extension = divPadre.find('.d-extension');
        var nombre = divPadre.find('.d-nombre');
        var omitir = divPadre.find('.d-omitir');
        var url = boton.data('url');

        boton.attr('disabled', true);
        var icono = boton.find('i');
        icono.removeClass('fa-search').addClass('fa-spinner').addClass('animacion-rotar');

        var spanError = nombre.next();
        if(spanError.is('span')) {
            spanError.remove();
        }

        $.post(
            url,
            {
                nombre: nombre.val(),
                extension: extension.find(':selected').html()
            },
            function(data) {
                if(!data.error) {
                    if(data.disponible) {
                        $.fn.alertaModal('Dominio disponible', data.mensaje, 'success');
                    }
                    else {
                        $.fn.alertaModal('Dominio no disponible', data.mensaje, 'warning');
                    }
                }
                else {
                    $.fn.alertaModal('Error inesperado', data.mensaje, 'danger');
                }
            }
        )
        .fail(function() {
            $.fn.alertaModal('ERROR', 'Un error inesperado ha surgido, por favor intente nuevamente', 'danger');
        })
        .always(function() {
            boton.attr('disabled', false);
            icono.removeClass('fa-spinner').removeClass('animacion-rotar').addClass('fa-search');
        });
    });


    $('.calcular-hosting').on("change", function(e) {
        $.fn.calcularHosting($(this));
        $.fn.calcularTotal();
    });


    $.fn.calcularDominio = function(input) {

        var numero = input.attr('id').match(/\d+/g);
        var divPadre = input.parents('div.orden-dominio');
        var extension = divPadre.find('.d-extension.calcular-dominio');
        var duracion = divPadre.find('.d-duracion.calcular-dominio');
        var omitir = divPadre.find('.d-omitir.calcular-dominio');

        var hResumen = $('.dominio-resumen-' + numero);
        var hPrecio = $('.dominio-precio-' + numero);
        var costo = 0;

        if(omitir.is(":checked") == false) {
            var anios = duracion.val();
            costo = extension.find(':selected').data('costo-' + anios);
            var label = extension.find(':selected').html();
            hResumen.html('Dominio <strong>' + label + '</strong> (' + anios + ' años)');
        }
        else {
            hResumen.html('Dominio <strong>No aplica</strong>');
        }
        hPrecio.html('$' + $.fn.numberFormat(costo));
        return costo;
    }


    $('.calcular-dominio').on("change", function(e) {
        $.fn.calcularDominio($(this));
        $.fn.calcularTotal();
    });

    $('#orden-registro').on("submit", function(e) {
        $('#boton-registro-orden').attr('disabled', true);
    });

    $('.custom-file-input').on('change', function(){
        var fileName = $(this).val();
        $(this).next('.custom-file-label').html(fileName);
    });


    $('#boton-registro-orden').on("click", function(e) {
        var boton = $(this);
        var total = $.fn.calcularTotal();
        if(total == 0) {
            $.fn.alertaModal('Orden incompleta', 'Debe al menos ordenar un servicio', 'danger');
            e.preventDefault();
        }
        else {
            if($.fn.siguienteForm()) {
                e.preventDefault();
            }
            else {
                $.fn.formIsValid();
            }
        }
    });

    $('select.indicar-pago').on("change", function(e) {
        $.fn.mostrarFormPagos();
    });

    $('.h-omitir, .d-omitir, .f-omitir, .p-omitir').on("click", function(e) {
        $.fn.omitirFormulario();
    });


    $('div.tab-area a.nav-link').on("click", function(e) {
        $.fn.activeTab($(this));
    });

    $(window).on("load", function(e) {
        $.fn.tabError(true);
        $.fn.cargarDefault();
        $.fn.calcularTotal();
        $.fn.omitirFormulario();
        $.fn.mostrarFormPagos();
    });


})(jQuery, window, document);