(this, function($, window, document) {
    "use strict";



    $('a.ver-extension').on('click', function(e) {

        var enlace = $(this);
        var url = enlace.data('url');

        $.get(url, function(data) {
            if(!data.error) {
                var modal = $("#modal-ver-extesion");
                modal.find('.modal-title span.nombre-extension').html(data.datos.nombre);

                var costos = data.datos.costos;
                var html = '';

                if(data.datos.estatus == 1) {
                    modal.find('span.estatus-activar').html('Activo');
                }
                else {
                    modal.find('span.estatus-activar').html('Inactivo');
                }

                for (var i = 0; i < costos.length; i++) {
                    var style = '';
                    if(i % 2 == 0) {
                        style = 'style="background-color: rgba(0,0,0,.05);"';
                    }
                    html += '<div class="p-3 ver-costo d-flex justify-content-between" '+ style +'>';
                    html += '<div><span class="text-info">CLP $' + $.fn.numberFormat(costos[i].costo)  
                            + '</span></div>';
                    html += '<div>' + costos[i].duracion + ' A&ntilde;o(s)</div>';
                    html += '</div>';
                }

                modal.find('.modal-body .ver-costo').remove();
                modal.find('.modal-body').append(html);
                modal.modal('toggle');
            }
            else {
                $.fn.alertaModal('Error!', data.mensaje, 'danger');
            }
        })
        .fail(function() {
            $.fn.alertaModal('Error!', 'Un error inesperado ha surgido', 'danger');
        });
    });






    $('a.activar-extension').on('click', function(e) {

        var enlace = $(this);
        var id = enlace.data('id');
        var estatus = enlace.data('estatus');

        var fila = $('tr#extension-' + id);
        var modal = $('#modal-activar-extesion');

        $('#btn-activar-extesion').data('id', id);

        var nombre = fila.find('td.nombre-extension').html();
        modal.find('span.nombre-activar').html(nombre);

        if(estatus == '1') {
            modal.find('span.estatus-activar').html('Desactivar');
        }
        else {
            modal.find('span.estatus-activar').html('Activar');
        }

        modal.modal('toggle');
    });

    $('#btn-activar-extesion').on('click', function(e) {

        var btn = $(this);
        var id = btn.data('id');
        var fila = $('tr#extension-' + id);
        var url = fila.find('a.activar-extension').data('url');       

        $.get(url, function(data) {
            if(!data.error) {
                fila.find('i.estatus-icono').toggleClass('fa-ban fa-check-circle');
                fila.find('i.estatus-icono').toggleClass('text-success text-danger');
                var enlace = fila.find('a.activar-extension');

                if(data.estatusFinal == 1) {
                    fila.find('span.estatus-nombre').html('Activo');
                    enlace.data('estatus', data.estatusFinal);
                }
                else {
                    fila.find('span.estatus-nombre').html('Inactivo');
                    enlace.data('estatus', data.estatusFinal);
                }

                $.fn.alertaModal('Exito!', data.mensaje, 'success');
            }
            else {
                $.fn.alertaModal('Error!', data.mensaje, 'danger');
            }
            $("#modal-activar-extesion").modal('hide');
        })
        .fail(function() {
            $("#modal-activar-extesion").modal('hide');
            $.fn.alertaModal('Error!', 'Un error inesperado ha surgido', 'danger');
        });
    });


    

})(jQuery, window, document);