(function ($, window, document) {
    'use strict';

    $('#modal-anular-orden').on('show.bs.modal', function (event) {
        var trigger = $(event.relatedTarget);
        var url = trigger.data('url');
        var id = trigger.data('id');
        var correlativo = trigger.data('correlativo');

        $('#btn-anular-orden').data('url', url);
        $('#btn-anular-orden').data('id', id);
        $('#orden-nro-eliminar').html(correlativo);
    });

    $('#btn-anular-orden').on('click', function (event) {
        var btn = $(this);
        var url = btn.data('url');
        var id = btn.data('id');

        $.get(url, function(data) {
            if(!data.error) {
                btn.data('url', '').data('id', '');
                $('#link-anular-' + id).remove();


                $('.estatus-orden-' + id).html('<i class="text-danger fas fa-ban fa-lg"></i> Anulada');


                $.fn.alertaModal('Exito!', data.mensaje, 'success');
            }
            else {
                $.fn.alertaModal('Error!', data.mensaje, 'danger');
            }
            $("#modal-anular-orden").modal('hide');
        })
        .fail(function() {
            $("#modal-anular-orden").modal('hide');
            $.fn.alertaModal('Error!', 'Un error inesperado ha surgido', 'danger');
        });
    });


    /*$(window).on("load", function (e) {

    });*/

})(jQuery, window, document);