<?php
namespace App\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

use Symfony\Component\Form\Form;

use App\Entity\Dns;
use App\Entity\Usuario;
use App\Entity\Hosting;
use App\Entity\Dominio;
use App\Entity\OrdenCompra;

use App\Form\Hosting\HostingCredencialEnviarType;

class ClienteController extends AbstractController
{
    public function listar()
    {
        $clientes = $this->getDoctrine()->getRepository(Usuario::class)
            ->listadoCliente();

        return $this->render('admin/cliente/listar.html.twig', [
                'clientes' => $clientes
            ]);
    }

    public function servicio()
    {
        $id = $this->getUser()->getId();
        $ordenes = $this->getDoctrine()->getRepository(OrdenCompra::class)->listarUsuario($id);
        $hostings = $this->getDoctrine()->getRepository(Hosting::class)->listarUsuario($id);
        $dominios = $this->getDoctrine()->getRepository(Dominio::class)->listarUsuario($id);

        return $this->render('website/cliente/servicio.html.twig', [
            'hostings' => $hostings,
            'dominios' => $dominios,
            'ordenes' => $ordenes,
        ]);
    }

    public function servicioAdmin($id)
    {
        $usuario = $this->getDoctrine()->getRepository(Usuario::class)->find($id);

        if(!$usuario) {
            return $this->redirectToRoute('cliente_listar');
        }

        $ordenes = $this->getDoctrine()->getRepository(OrdenCompra::class)->listarUsuario($id);
        $hostings = $this->getDoctrine()->getRepository(Hosting::class)->listarUsuario($id);
        $dominios = $this->getDoctrine()->getRepository(Dominio::class)->listarUsuario($id);

        return $this->render('admin/cliente/servicio.html.twig', [
                'usuario' => $usuario,
                'hostings' => $hostings,
                'dominios' => $dominios,
                'ordenes' => $ordenes,
            ]);
    }

    public function enviarCredencialHost(Request $request, \Swift_Mailer $mailer, $id)
    {
        $dns = $this->getDoctrine()->getRepository(Dns::class)->findAll();
        $hosting = $this->getDoctrine()->getRepository(Hosting::class)->hostingDataSimple($id);

        if(!$hosting) {
            return $this->redirectToRoute('cliente_listar');
        }
        else {
            $hosting = $hosting[0];
        }

        $dataForm = ['dominio' => null, 'username' => null, 'password' => null, 'ipTemp' => null];
        $form = $this->createForm(HostingCredencialEnviarType::class, $dataForm);
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            $data = $form->getData();
            if($form->isValid()) {
                $return = $this->correoEnviarCredenciaHosting($mailer, $hosting, $dns, $form->getData());
                $this->addFlash('success', 'Las credenciales han sido enviadas exitosamente');

                return $this->redirectToRoute('cliente_servicio_admin', [
                    'id' => $hosting['usuarioId']
                ]);
            }
        }

        return $this->render('admin/cliente/credencial_hosting.html.twig', [
            'form' => $form->createView(),
            'hosting' => $hosting,
            'dns' => $dns,
        ]);
    }

    private function correoEnviarCredenciaHosting(\Swift_Mailer $mailer, $hosting, $dns, $form) {

        $emailUsuario = $this->getUser()->getEmail();

        $message = (new \Swift_Message('Credenciales del Hosting'))
            ->setFrom('no.responder@netnexo.cl')
            ->addCc('gestion@netnexo.cl')
            ->setTo($hosting['email']);

        $message->setBody(
                $this->renderView(
                    'correo/credencial_hosting.html.twig', [
                        'form' => $form,
                        'hosting' => $hosting,
                        'dns' => $dns,
                    ]
                ),
                'text/html'
            );

        $mailer->send($message);
    }
}