<?php

namespace App\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

use App\Entity\Extension;
use App\Entity\ExtensionCosto;

use App\Form\Extension\ExtensionEditarType;

class ExtensionController extends AbstractController
{
    public function listar() 
    {
        $extensiones = $this->getDoctrine()->getRepository(Extension::class)
            ->listadoAdmi();

        return $this->render('admin/extension/listar.html.twig', ['extensiones' => $extensiones]);
    }

    public function ver($id) {
        $error = true;
        $mensaje = '';
        $datos = [];
        $response = new JsonResponse();
        $objExt = $this->getDoctrine()->getRepository(Extension::class)->find($id);

        if($objExt) {
            $error = false;
            $costos = $objExt->getCosto();
            $datos['nombre'] = $objExt->getNombre();
            $datos['estatus'] = $objExt->getEstatus();
            foreach ($costos as $costo) {
                $datos['costos'][] = ['costo' => $costo->getCosto(), 'duracion' => $costo->getAnio()];
            }
        }
        else {
            $mensaje = 'La Extension no existe o ha sido eliminada.';
        }

        return $response->setData(['error' => $error, 'mensaje' => $mensaje, 'datos' => $datos]);
    }

    public function editar(Request $request, $id) {

        $extension = $this->getDoctrine()->getRepository(Extension::class)->find($id);

        if(!$extension) {
            return $this->redirectToRoute('extension_lista');
        }
        else {
            $form = $this->createForm(ExtensionEditarType::class, $extension);
            $form->handleRequest($request);

            if ($form->isSubmitted()) {
                if($form->isValid()) {

                    $objDB = $this->getDoctrine()->getManager();
                    $objDB->persist($extension);
                    $objDB->flush();
                    $this->addFlash('success', 'Se han actualizado los precios con exito');
                    return $this->redirectToRoute('extension_lista');
                }
            }
        }

        return $this->render('admin/extension/editar.html.twig', 
            [
                'form' => $form->createView(),
                'extension' => $extension
            ]
        );
    }

    public function activar($id)
    {
        $error = true;
        $mensaje = '';
        $response = new JsonResponse();
        $objExt = $this->getDoctrine()->getRepository(Extension::class)->find($id);

        if($objExt) {
            $activo = 'Activada';
            $estatusFinal = Extension::ESTATUS_ACTIVO;

            if($objExt->getEstatus() == Extension::ESTATUS_ACTIVO) {
                $objExt->setEstatus(Extension::ESTATUS_INACTIVO);
                $estatusFinal = Extension::ESTATUS_INACTIVO;
                $activo = 'Inactivo';
            }
            else {
                $objExt->setEstatus(Extension::ESTATUS_ACTIVO);
            }

            $objDB = $this->getDoctrine()->getManager();
            $objDB->persist($objExt);
            $objDB->flush();
            $response->setStatusCode(Response::HTTP_OK);
            $error = false;
            $mensaje = 'La Extension ha sido ' .$activo. ' con exito.';
        }
        else {
            $mensaje = 'La Extension no existe o ha sido eliminada.';
        }

        return $response->setData(['error' => $error, 'mensaje' => $mensaje, 'estatusFinal' => $estatusFinal]);
    }

}