<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Entity()
 * @ORM\Table(name="cuentas")
 * @ORM\HasLifecycleCallbacks
 */
class Cuenta
{
    ////////////////
    // CONSTANTES //
    ////////////////

    public const ESTATUS_ACTIVO = 1;
    public const ESTATUS_INACTIVO = 2;

    public const ESTATUS = [
        self::ESTATUS_ACTIVO,
        self::ESTATUS_INACTIVO
    ];


    ///////////////
    // ATRIBUTOS //
    ///////////////

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Banco")
     * @ORM\JoinColumn(name="banco_id", referencedColumnName="id", nullable=false)
     * @Assert\NotBlank()
     */
    private $banco;

    /**
     * @ORM\Column(type="string", length=100, nullable=false)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 4,
     *      max = 100
     * )
     */
    private $titular;

    /**
     * @ORM\Column(type="string", length=100, nullable=false)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 4,
     *      max = 100
     * )
     */
    private $numero;

    /**
     * @ORM\Column(type="string", length=100, nullable=false)
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 4,
     *      max = 100
     * )
     */
    private $documento;


    /**
     * @var int
     *
     * @ORM\Column(type="integer", options={"default":1})
     */
    private $estatus;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $updatedAt;


    /////////////////
    // CONSTRUCTOR //
    /////////////////
    public function __construct()
    {
        $this->estatus = 1;
    }


    /////////////////////
    // GETTER - SETTER //
    /////////////////////

    /**
     * @return int
     */
    public function getId() : ?int
    {
        return $this->id;
    }

    /**
     * @return Banco
     */
    public function getBanco() : ?Banco
    {
        return $this->banco;
    }

    /**
     * @param Banco $banco
     *
     * @return self
     */
    public function setBanco(Banco $banco)
    {
        $this->banco = $banco;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitular() : ?string
    {
        return $this->titular;
    }

    /**
     * @param string $titular
     *
     * @return self
     */
    public function setTitular($titular) : self
    {
        $this->titular = $titular;
        return $this;
    }

    /**
     * @return string
     */
    public function getNumero() : ?string
    {
        return $this->numero;
    }

    /**
     * @param string $numero
     *
     * @return self
     */
    public function setNumero($numero) : self
    {
        $this->numero = $numero;
        return $this;
    }

    /**
     * @return string
     */
    public function getDocumento() : ?string
    {
        return $this->documento;
    }

    /**
     * @param string $documento
     *
     * @return self
     */
    public function setDocumento($documento) : self
    {
        $this->documento = $documento;
        return $this;
    }

    /**
     * @return int
     */
    public function getEstatus() : ?int
    {
        return $this->estatus;
    }

    /**
     * @param string $nombre
     *
     * @return self
     */
    public function setEstatus(int $estatus) : self
    {
        $this->estatus = $estatus;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt() : ?\DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdateAt() : ?\DateTime
    {
        return $this->updatedAt;
    }

    /////////////////////////
    // LIFECYCLE CALLBACKS //
    /////////////////////////

    /**
     * @ORM\PrePersist()
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate()
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }

    /////////////////////
    // OTRAS FUNCIONES //
    /////////////////////

    public function getAllEstatus() {
        return self::ESTATUS;
    }

}