<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\Collection;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity()
 * @ORM\Table(name="extension_costo")
 * @ORM\HasLifecycleCallbacks
 * @ORM\Entity(repositoryClass="App\Repository\ExtensionCostoRepository")
 */
class ExtensionCosto
{

    ///////////////
    // CONSTANTE //
    ///////////////

    public const MAX_ANIO = 5;

    ///////////////
    // ATRIBUTOS //
    ///////////////

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(type="float")
     * @Assert\Regex(
     *     pattern = "/^(([0-9]{1,8})(\.[0-9]{1,2})?)$/",
     *     message="Debe ingresar un numero valido, opcionalmente con 2 decimales. Ejm: 15900.50",
     *     groups={"editar"}
     * )
     * @Assert\NotBlank(groups={"editar"})
     */
    private $costo;

    /**
     * @var int
     *
     * @ORM\Column(type="integer")
     * @Assert\NotBlank(groups={"editar"})
     * @Assert\Type("integer", groups={"editar"})
     * @Assert\Range(
     *      min = 1,
     *      max = ExtensionCosto::MAX_ANIO,
     *      groups={"editar"}
     * )
     */
    private $anio;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $createdAt;

    /**
     * @var \DateTime
     *
     * @ORM\Column(type="datetime")
     */
    private $updatedAt;

    /**
     * @ORM\ManyToOne(targetEntity="Extension", inversedBy="costo")
     * @ORM\JoinColumn(name="extension_id", referencedColumnName="id", nullable=false)
     */
    private $extension;


    /////////////////////
    // GETTER - SETTER //
    /////////////////////

    /**
     * @return int
     */
    public function getId() : ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCosto() : ?float
    {
        return $this->costo;
    }

    /**
     * @param string $nombre
     *
     * @return self
     */
    public function setCosto($costo) : self
    {
        $this->costo = $costo;
        return $this;
    }

    public function getAnio() : ?int
    {
        return $this->anio;
    }

    /**
     * @param string $nombre
     *
     * @return self
     */
    public function setAnio($anio) : self
    {
        $this->anio = $anio;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt() : ?\DateTime
    {
        return $this->createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdateAt() : ?\DateTime
    {
        return $this->updatedAt;
    }

    /**
     * @return Extension
     */
    public function getExtension() : ?Extension
    {
        return $this->extension;
    }

    /**
     * @param Extension $extension
     *
     * @return self
     */
    public function setExtension(Extension $extension) : self
    {
        $this->extension = $extension;
        return $this;
    }

    /////////////////////////
    // LIFECYCLE CALLBACKS //
    /////////////////////////

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * @ORM\PreUpdate
     */
    public function preUpdate()
    {
        $this->updatedAt = new \DateTime();
    }


    ////////////////////////////
    // METODOS PERSONALIZADOS //
    ////////////////////////////

}