<?php

namespace App\Form\Orden;

use App\Entity\OrdenCompra;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

use Symfony\Component\Validator\Constraints as Assert;

class OrdenCompraPagarType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('transferencias', CollectionType::class, [
                'entry_type' => TransferenciaNuevoType::class,
                'by_reference' => false,
                'required' => false,
            ])
            ->add('depositos', CollectionType::class, [
                'entry_type' => DepositoNuevoType::class,
                'by_reference' => false,
                'required' => false,
            ])
            ->add('metodopago', ChoiceType::class, [
                'mapped' => false,
                'attr' => ['class' => 'custom-select indicar-pago'],
                'choices' => [
                    OrdenCompra::PAGO_LABEL[OrdenCompra::PAGO_TRANSFERENCIA] => OrdenCompra::PAGO_TRANSFERENCIA,
                    OrdenCompra::PAGO_LABEL[OrdenCompra::PAGO_DEPOSITO] => OrdenCompra::PAGO_DEPOSITO,
                    OrdenCompra::PAGO_LABEL[OrdenCompra::PAGO_WEBPAY] => OrdenCompra::PAGO_WEBPAY
                ],
                'choice_attr' => function($choiceValue, $key, $value) {
                    $attr = [];
                    if($value == '3') {
                        $attr = ['disabled' => 'disabled'];
                    }
                    return $attr;
                },
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OrdenCompra::class,
            'validation_groups' => function (FormInterface $form) {
                $metodopago = $form->get('metodopago')->getData();
                $grupos = [];
                if (OrdenCompra::PAGO_TRANSFERENCIA == $metodopago) {
                    $grupos[] = 'transferenciaNuevo';
                }
                else if (OrdenCompra::PAGO_DEPOSITO == $metodopago) {
                    $grupos[] = 'depositoNuevo';
                }
                return $grupos;
            }
        ]);
    }
}