<?php

namespace App\Form\Orden;

use App\Entity\OrdenCompra;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

use Symfony\Component\Validator\Constraints as Assert;

class OrdenCompraProcesarType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('ordenHosting', CollectionType::class, [
                'entry_type' => OrdenHostingProcesarType::class,
                'by_reference' => false,
                'entry_options' => [
                    'required'=> false
                ]
            ])
            ->add('ordenDominio', CollectionType::class, [
                'entry_type' => OrdenDominioProcesarType::class,
                'by_reference' => false,
                'entry_options' => [
                    'required'=> false
                ]
            ])
            ->add('observacion', TextareaType::class, [
                'required'=> false,
                'attr' => ['class' => 'form-control'],
            ])
            ->add('nota', TextareaType::class, [
                'required'=> false,
                'attr' => ['class' => 'form-control'],
            ]);
    }


    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OrdenCompra::class,
            'validation_groups' => ['procesar', 'procesarDom', 'procesarHst']
        ]);
    }
}