<?php

namespace App\Form\Orden;

use App\Entity\OrdenDominio;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;

use Symfony\Component\Validator\Constraints as Assert;

class OrdenDominioProcesarType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('estatus', ChoiceType::class, [
                'attr' => ['class' => 'custom-select orden-estatus'],
                'choices' => [
                    OrdenDominio::ESTATUS_LABEL[OrdenDominio::ESTATUS_RECHAZADA]=>OrdenDominio::ESTATUS_RECHAZADA,
                    OrdenDominio::ESTATUS_LABEL[OrdenDominio::ESTATUS_APROBADA]=>OrdenDominio::ESTATUS_APROBADA,
                ],
            ])
            ->add('observacion', TextareaType::class,[
                'attr' => ['class' => 'form-control'],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OrdenDominio::class,
        ]);
    }
}