<?php

namespace App\Form\Orden;

use App\Entity\Pais;
use App\Entity\OrdenFactura;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;



class OrdenFacturaNuevoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder
            ->add('nombre', TextType::class)
            ->add('dni', TextType::class)
            ->add('giro', TextType::class)
            ->add('fono', TextType::class)
            ->add('telefono', TextType::class)
            ->add('direccion', TextareaType::class)
            ->add('comuna', TextType::class)
            ->add('ciudad', TextType::class)
            ->add('pais', EntityType::class, [
                'class' => Pais::class,
                'choice_label' => 'nombre',
                'attr' => ['class' => 'custom-select']
            ]);
    }


    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OrdenFactura::class,
        ]);
    }
}