<?php

namespace App\Form\Orden;

use App\Entity\Plan;
use App\Entity\OrdenHosting;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;

use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

use Symfony\Component\Validator\Constraints as Assert;


class OrdenHostingNuevoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('planDestino', EntityType::class, [
                'class' => Plan::class,
                'attr' => ['class' => 'calcular-hosting h-plan custom-select'],
                'choice_label' => 'nombre',
                'choice_attr' => function($plan, $key, $value) {
                    $tmp = [];
                    $costos = $plan->getCostos();
                    foreach ($costos as $costo) {
                        $tmp['data-costo-' . $costo->getAnio()] = $costo->getCosto();
                    }
                    return $tmp;
                },
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('e')
                        ->where('e.estatus = :estatus')
                        ->setParameter('estatus', Plan::ESTATUS_ACTIVO);
                },
                
            ])
            ->add('duracion', ChoiceType::class, [
                'attr' => ['class' => 'calcular-hosting h-duracion custom-select'],
                'choices' => $this->getDuracion(),
            ])
            ->add('detalle', TextType::class, [
                'required' => false,
                'label' => 'Dominio a usar'
            ])
            ->add('omitirHosting', CheckboxType::class, [
                'attr' => ['class' => 'calcular-hosting h-omitir'],
                'label'    => 'No deseo comprar un Hosting en estos momentos',
                'mapped' => false,
                'required' => false
            ]);
    }

    private function getDuracion() {
        $anio = $label = [];
        for ($i=1; $i <= Plan::MAX_ANIO; $i++) { 
            $tmp[$i] = $i;
            $label[$i] = $i . ' Año(s)';
        }
        return array_combine($label,$tmp);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OrdenHosting::class,
            'validation_groups' => function (FormInterface $form) {
                $grupos = [];
                $omitirHosting = $form->get('omitirHosting')->getData();
                if (true != $omitirHosting) {
                    $grupos = ['registrarOrd'];
                }
                return $grupos;
            }
        ]);

    }
}