<?php

namespace App\Form\Plan;

use App\Entity\Plan;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;

use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

use Symfony\Component\Validator\Constraints as Assert;

class PlanNuevoEditarType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nombre', TextType::class)
            ->add('descripcion', TextType::class)
            ->add('costos', CollectionType::class, [
                'entry_type' => PlanCostoEditarType::class,
                'by_reference' => true,
                'entry_options' => [
                    'required'=> true,
                    'constraints' => [new Assert\Valid(['groups' => ['nuevo']])],
                ]
            ])
            ->add('detalles', CollectionType::class, [
                'entry_type' => PlanDetalleEditarType::class,
                'by_reference' => true,
                'entry_options' => [
                    'required'=> true,
                    'constraints' => [new Assert\Valid(['groups' => ['nuevo']])],
                ]
            ]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Plan::class,
            'validation_groups' => ['nuevo'],
        ]);
    }
}