<?php

namespace App\Form\Usuario;

use App\Entity\Usuario;
use App\Entity\Persona;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;

use Symfony\Component\Validator\Constraints as Assert;

class UsuarioNuevoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('username', TextType::class, [
                'attr' => ['class' => 'text-lower'],
            ])
            ->add('plainPassword', RepeatedType::class, [
                'required' => false,
                'type' => PasswordType::class,
                'invalid_message' => 'Las contraseñas no coinciden.',
            ])
            ->add('email', EmailType::class, [
                'required' => false,
                'attr' => ['class' => 'text-lower'],
            ])
            ->add('persona', PersonaNuevoType::class);
    }


    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Usuario::class,
            // nuevoUsuario se usa para aplicar el @assert/valid{grupo}
            //      de la relacion con Persona y asi ejecutar los 
            //      assert de usuario que tengan dicho grupo
            'validation_groups' => ['nuevo', 'nuevoUsuario']
        ]);
    }
}