<?php

namespace App\Repository;

use App\Entity\Extension;
use Doctrine\ORM\EntityRepository;

class ExtensionRepository extends EntityRepository
{
    public function listadoAdmi() {

        $entityManager = $this->getEntityManager();
        $extensiones = $entityManager->createQuery(
            'SELECT 
                ex.id, ex.estatus, ex.nombre, MIN(co.costo) costo
            FROM 
                App\Entity\Extension ex,
                App\Entity\ExtensionCosto co
            WHERE
                co.extension = ex.id
            GROUP BY 
                ex.id
            ORDER BY 
                ex.estatus, ex.nombre, costo , ex.id ASC'
        )
        ->execute();

        return $extensiones;
    }

}


