<?php

namespace App\Repository;

use App\Entity\PlanCaracteristica;
use Doctrine\ORM\EntityRepository;

class PlanCaracteristicaRepository extends EntityRepository
{
    public function getActivosIndexId() {

        $query = $this->createQueryBuilder('p', 'p.id')
            ->select('p.id')
            ->addSelect('p.nombre')
            ->where('p.estatus = 1')
            ->orderBy('p.estatus', 'ASC')
            ->orderBy('p.nombre', 'ASC')
            ->getQuery();
        return $query->execute();
    }

    public function existeNombre($id, $nombre) {

        $query = $this->createQueryBuilder('p')
            ->select('p.id')
            ->andWhere('p.nombre = :nombre')
            ->andWhere('p.id != :id')
            ->setParameter('nombre', $nombre)
            ->setParameter('id', $id)
            ->setMaxResults(1)
            ->getQuery();

        return $query->getOneOrNullResult();
    }


}