<?php

namespace App\Repository;

use App\Entity\PlanCosto;
use Doctrine\ORM\EntityRepository;

class PlanCostoRepository extends EntityRepository
{
    public function costoAnio($planId, $anio) {
        $query = $this->createQueryBuilder('p')
            ->select('p.costo')
            ->andWhere('p.plan = :id')
            ->andWhere('p.anio = :anio')
            ->setParameter('id', $planId)
            ->setParameter('anio', $anio)
            ->setMaxResults(1)
            ->getQuery();

        return $query->getOneOrNullResult();
    }
}


