<?php

namespace App\Util;

class Whois
{
    private $dominio;
    private $extension;
    private $header;
    private $urlBase;
    private $urlFinal;

    private $info;
    private $conexion;
    private $resultado;

    //  
    //user : netnexo
    //pass : Pacita253

    //DEV
    //private $llave = '3mM44UYhwRAc1d_VgERNyEqnmMNcofHB6g3YQ';
    //private $secreto = 'VgEVmqvA8wvGC8De661LMi';

    //PROD
    private $llave = 'e42XCP5Fo6qK_Ti2okjx58GuWePUeFeqjdh';
    private $secreto = 'Ti2usZkr17jaD8NWyaVxoq';
    
    private $error;
    private $codigo;
    private $disponible;

    public function __construct() {
        $this->header = [
            "Authorization: sso-key {$this->llave}:{$this->secreto}"
        ];

        //DEV
        $this->urlBase = $url = 'https://api.ote-godaddy.com/v1/domains/available?checkType=FULL&domain=';

        //PRO
        $this->urlBase = $url = 'https://api.godaddy.com/v1/domains/available?checkType=full&domain=';

        $this->conexion = curl_init();
        curl_setopt($this->conexion, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($this->conexion, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($this->conexion, CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($this->conexion, CURLOPT_HTTPHEADER, $this->header);
        curl_setopt($this->conexion, CURLOPT_CONNECTTIMEOUT, 60);

        $this->iniciarVariables();
    }

    public function __destruct() {
        curl_close($this->conexion);
    }

    public function iniciarVariables() {
        $this->error = false;
        $this->codigo = 0;
        $this->disponible = false;
        $this->info = null;
    }

    public function setConsulta(string $dominio, string $extension) {
        $this->dominio = $dominio;
        $this->extension = $extension;
        $this->urlFinal = $this->urlBase . $dominio . '.' . $extension;
        return $this;
    }

    public function consultar() {
        $this->iniciarVariables();
        if($this->formatoValido()) {
            curl_setopt($this->conexion, CURLOPT_URL, $this->urlFinal);
            try {
                $this->resultado = curl_exec($this->conexion);    
            }
            catch (\Exception $e) {
                throw $e;
            }
            $this->info = curl_getinfo($this->conexion);
            $this->validarRespuesta();
        }
        return $this->disponible;
    }

    public function formatoValido() {
        $valido = true;
        if(preg_match('/^([a-z\d](-*[a-z\d])*)(([a-z\d](-*[a-z\d])*))*$/', $this->dominio) !== 1) {
            $valido = false;
            $this->error = true;
            $this->codigo = -1;
        }
        return $valido;
    }


    private function validarRespuesta() {
        if($this->resultado === false || curl_errno($this->conexion) !== 0) {
            $this->error = true;
            $this->codigo = curl_errno($this->conexion);
        }
        else {
            $this->resultado = json_decode($this->resultado, true);
            if(array_key_exists('http_code', $this->info) && $this->info['http_code'] === 200) {
                if(array_key_exists('available', $this->resultado)) {
                    if($this->resultado['available'] === true) {
                        $this->disponible = true;
                    }
                }
                else {
                    $this->error = true;
                    $this->codigo = 419;
                }
            }
            else {
                $this->error = true;
                $this->codigo = $this->info['http_code'];
            }
        }
    }

    public function getInfo() {
        return $this->info;
    }

    public function getResultado() {
        return $this->resultado;
    }

    public function getCodigo() {
        return $this->codigo;
    }

    public function getDisponible() {
        return $this->disponible;
    }

    public function getError() {
        return $this->error;
    }


}