<?php

namespace App\Validator\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

use App\Util\Whois;

class DominioDisponibleValidator extends ConstraintValidator
{
    public function validate($ordenDominio, Constraint $constraint)
    {
        if (!$constraint instanceof DominioDisponible) {
            throw new UnexpectedTypeException($constraint, DominioDisponible::class);
        }

        $nombreDom = $ordenDominio->getNombre();
        $extensionDom = $ordenDominio->getExtension()->getNombre();
        $nombreCompleto = $nombreDom.'.'.$extensionDom;

        $error = false;
        $whois = new Whois();
        $disponible = $whois->setConsulta($nombreDom, $extensionDom)->consultar();

        if($disponible == false) {
            $error = true;
            $errorWhois = $whois->getError();
            if($errorWhois === true) {
                $codigo = $whois->getCodigo();
                if($codigo == 429) {
                    $mensaje = "Sistema de consulta saturado";
                }
                elseif($codigo == 401 || $codigo == 403) {
                    $mensaje = "Problema de autenticacion en la consulta del Dominio";
                }
                else {
                    $mensaje = "Ha surgido un error inesperado en la consulta del Dominio";
                    if($codigo == 422) {
                        $resultado = $whois->getResultado();
                        if($resultado['code'] == 'UNSUPPORTED_TLD') {
                            $mensaje = 'Extension de Dominio no valida para consultar';
                        }
                    }
                }
            }
            else {
                $mensaje = "El Dominio {$nombreCompleto} no se encuentra disponible";
            }
        }

        if ($error) {
            $this->context->buildViolation($constraint->message)
                ->atPath('nombre')
                ->setParameter('{{ string }}', $mensaje)
                ->addViolation();
        }
    }
}